﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="VIRP_WEB.Controls.Custom.BPR.controls_UserControlAdminFlagFilter" Codebehind="UserControlAdminFlagFilter.ascx.cs" %>
<%@ Register Src="UserControlFromToDate.ascx" TagName="UserControlFromToDate" TagPrefix="UserControl" %>


<script type = "text/javascript">
    $(document).ready(function() {

        var rangeValidatorFromDate = document.getElementById('<%= "RangeValidatorTextBoxFromDate" %>');
        var rangeValidatorToDate = document.getElementById('<%= "RangeValidatorTextBoxToDate" %>');
        var dropDownListAdminFlag = document.getElementById('<%= "DropDownListAdminFlag" %>');
        var textBoxFromDate = document.getElementById('<%= "TextBoxFromDate" %>');
        var textBoxToDate = document.getElementById('<%= "TextBoxToDate" %>');

        if(dropDownListAdminFlag != null)
        {
            if (dropDownListAdminFlag.value == "") {
                $('#<%= PanelAdminFlagDate.ClientID %>').hide();
                ValidatorEnable(rangeValidatorFromDate, false);
                ValidatorEnable(rangeValidatorToDate, false);
            }
            else {
                $('#<%= PanelAdminFlagDate.ClientID %>').show();
                ValidatorEnable(rangeValidatorFromDate, true);
                ValidatorEnable(rangeValidatorToDate, true);
            }

            dropDownListAdminFlag.change(function () {
                if (this.value == "") {
                    $('#<%= PanelAdminFlagDate.ClientID %>').hide();
                    ValidatorEnable(rangeValidatorFromDate, false);
                    ValidatorEnable(rangeValidatorToDate, false);
                    textBoxFromDate.val("");
                    TextBoxToDate.val("");
                }
                else {
                    $('#<%= PanelAdminFlagDate.ClientID %>').show();
                    ValidatorEnable(rangeValidatorFromDate, true);
                    ValidatorEnable(rangeValidatorToDate, true);
                }
                
            }
            )
        }
    });
</script>
<asp:Panel runat="server" ID="PanelAdminFlagSearchCriteria" BorderWidth="0" GroupingText="Admin Flag&nbsp&nbsp" role="heading" aria-level="2"
     ToolTip="Admin Flag is a flag on the registrant record set by a Clinical Portal user.  A registrant record could have more than one of the same Admin Flag.  The Selection Criteria allows the user to filter with one Admin Flag and a date range the flag was set.">
    <table>
        <tr>
            <td>
                <asp:Label SkinID="DataLabel" ID="LabelforDropDownListAdminFlag" runat="server" 
                        AssociatedControlID="DropDownListAdminFlag" EnableViewState="false" Text="Admin Flag:&nbsp&nbsp"
                        ToolTip="Admin Flag is a flag on the registrant record set by a Clinical Portal user.  A registrant record could have more than one of the same Admin Flag.  The Selection Criteria allows the user to filter with one Admin Flag and a date range the flag was set."></asp:Label>
                <br />
                <asp:DropDownList ID="DropDownListAdminFlag" runat="server" AppendDataBoundItems="true"
                     ToolTip="Admin Flag is a flag on the registrant record set by a Clinical Portal user.  A registrant record could have more than one of the same Admin Flag.  The Selection Criteria allows the user to filter with one Admin Flag and a date range the flag was set.">
                    <asp:ListItem Value="">-- Select an Admin Flag --</asp:ListItem>
                </asp:DropDownList>
            </td>
            <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
            <td>
                <asp:Panel ID="PanelAdminFlagDate" runat="server">
                <asp:Panel runat="server" ID="PanelDateRange" BorderWidth="0">
                            <table>
                            <tr>
                            <td role="textbox" aria-label="Admin Flag Entered From Date">
                                <asp:Label SkinID="DataLabel" ID="LabelforTextBoxFromDate" runat="server" 
                                    AssociatedControlID="TextBoxFromDate" EnableViewState="false" Text="From Date (mm/dd/yyyy):&nbsp&nbsp" ></asp:Label>
                                <asp:TextBox ID="TextBoxFromDate" runat="server" Width="100px"  class='textInput' />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorTextBoxFromDate" runat="server" 
                                    ControlToValidate = "TextBoxFromDate"  Display="Dynamic" EnableClientScript="true"  ForeColor="Red"
                                    SetFocusOnError="true" ErrorMessage="From Date is Required" ValidationGroup="OnRunReport">
                                </asp:RequiredFieldValidator>
                           </td>
                            <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
                            <td role="textbox" aria-label="Admin Flag Entered To Date">
                                <asp:Label SkinID="DataLabel" ID="LabelforTextBoxToDate" runat="server" 
                                    AssociatedControlID="TextBoxToDate" EnableViewState="false" Text="To Date (mm/dd/yyyy):&nbsp&nbsp" ></asp:Label>
                                <asp:TextBox ID="TextBoxToDate" runat="server" Width="100px" class='textInput' />
                                 <asp:RequiredFieldValidator ID="RequiredFieldValidatorTextBoxToDate" runat="server" 
                                    ControlToValidate = "TextBoxToDate"  Display="Dynamic" EnableClientScript="true"  ForeColor="Red"
                                    SetFocusOnError="true" ErrorMessage="To Date is Required" ValidationGroup="OnRunReport">
                                </asp:RequiredFieldValidator>
                             </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:CompareValidator runat="server" ID="CompareValidatorTextBoxFromDate" 
                                        Enabled="true" ForeColor="Red" Display="Dynamic"  ValidationGroup="OnRunReport"
                                        EnableClientScript="true"  SetFocusOnError="true" Type="Date" ValueToCompare="01/01/4000" 
                                        ControlToValidate = "TextBoxFromDate" Operator="LessThanEqual" 
                                        ErrorMessage="Please enter a valid From Date (mm/dd/yyyy). (Note: Future date is not allowed)">
                                    </asp:CompareValidator>        
                                </td>
                                <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
                                <td>
                                <asp:CompareValidator runat="server" ID="CompareValidatorTextBoxToDate" 
                                    Enabled="true" ForeColor="Red" Display="Dynamic"  ValidationGroup="OnRunReport"
                                    EnableClientScript="true"  SetFocusOnError="true" Type="Date" ValueToCompare="01/01/4000" 
                                    ControlToValidate = "TextBoxToDate" Operator="LessThanEqual" 
                                    ErrorMessage="Please enter a valid To Date (mm/dd/yyyy). (Note: Future date is not allowed)">
                                </asp:CompareValidator>        
                                </td>
                            </tr>
                            </table>
                            <asp:CustomValidator ID="CustomValidatorFromToDate" runat="server" ForeColor="Red"
                                ErrorMessage="To Date must be greater than or equal to From Date." ValidationGroup="OnRunReport" 
                                SetFocusOnError= "true" >
                           </asp:CustomValidator>
                        </asp:Panel>

            </asp:Panel>
           </td>
        </tr>
    </table>
</asp:Panel>
<asp:HiddenField ID="HiddenFieldAdminFlag" runat="server" />
<asp:HiddenField ID="HiddenFieldAdminFlagFromDate" runat="server" />
<asp:HiddenField ID="HiddenFieldAdminFlagToDate" runat="server" />
